import { DEFAULT_SWR_OPTIONS_FOR_GLOBAL_VALUES } from "@/config/swr";
import { getAgencies } from "@/server/api.agencies";
import useSWR, { mutate, preload } from "swr";

const INTERNAL__key = ["USE_GET_AGENCIES"] as const

preload(INTERNAL__key, getAgencies)

export function useGetAgencies() {
  return useSWR(INTERNAL__key,
    getAgencies,
    DEFAULT_SWR_OPTIONS_FOR_GLOBAL_VALUES
  )
}

export function revalidateAgencies() {
  return mutate((k) => k === INTERNAL__key, undefined, ({
    populateCache(_, currentData) {
      return currentData
    },
    revalidate: true,
  }))
}
